local t = Def.ActorFrame {};
--t[#t+1] = LoadActor("Tabs")..{ InitCommand=cmd(draworder,100); }

t[#t+1] = Def.ActorFrame {
	Def.Quad { -- Mask Quad
		InitCommand=cmd(draworder,-2;x,CenterX()-143;y,Top();rotationz,-20;zoomto,8,94;diffuse,color("#000000");zwrite,true;blend,'BlendMode_NoEffect');
	};
	Def.Quad { -- Mask Quad
		InitCommand=cmd(draworder,-2;x,CenterX()+143;y,Top();rotationz,20;zoomto,8,94;diffuse,color("#000000");zwrite,true;blend,'BlendMode_NoEffect');
	};
	Def.Quad { -- Mask Quad P1 StepsDisplay
		InitCommand=cmd(draworder,-20;x,CenterX()-308;y,Top();rotationz,20;zoomto,8,128;diffuse,color("#000000");zwrite,true;blend,'BlendMode_NoEffect');
	};
	Def.Quad { -- Mask Quad P2 StepsDisplay
		InitCommand=cmd(draworder,-20;x,CenterX()+308;y,Top();rotationz,-20;zoomto,8,128;diffuse,color("#000000");zwrite,true;blend,'BlendMode_NoEffect');
	};
	Def.Quad {
		InitCommand=cmd(x,CenterX()-130;y,Top();zoomto,16,40;skewx,0.9;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2);valign,0;zwrite,true;ztest,true);
	};
	Def.Quad {
		InitCommand=cmd(x,CenterX();y,Top();zoomto,264,40;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2);valign,0;zwrite,true;ztest,true);
	};
	Def.Quad {
		InitCommand=cmd(x,CenterX()+130;y,Top();zoomto,16,40;skewx,-0.9;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2);valign,0;zwrite,true;ztest,true);
	};
	Def.Quad { -- Center Background Part
		InitCommand=cmd(draworder,-1;x,CenterX();y,Top();valign,0;zoomto,Width(),40;diffuse,color(LoadFile("ThemeColor.cfg","Settings"));zwrite,true;ztest,true);
	};
	Def.Quad { -- Background
		InitCommand=cmd(draworder,-2;x,CenterX();y,Top();valign,0;zoomto,Width(),40;diffuse,color("#000000"));
	};
};

for pn in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = Def.ActorFrame{
		Def.Quad{
			Name = "Score/Grade Quad";
			InitCommand=function(self)
				if pn == PLAYER_1 then self:x(Left()):halign(0):faderight(0.5) else self:x(Right()):halign(1):fadeleft(0.5) end
				self:y(Top()+40):valign(0):setsize(294,84):diffuse(FailQuadColor(pn))
			end;
		};
		Def.Quad{
			Name = "Panel Display Background Quad";
			InitCommand=function(self)
				if pn == PLAYER_1 then self:x(Left()):halign(0):faderight(0.5) else self:x(Right()):halign(1):fadeleft(0.5) end
				self:y(Top()+40+4+84):valign(0):setsize(294,290):diffuse(BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),1.5))
			end;
		};
		Def.Quad{
			Name = "Panel Display";
			InitCommand=function(self)
				if pn == PLAYER_1 then self:x(Left()):halign(0):faderight(1) else self:x(Right()):halign(1):fadeleft(1) end
				self:y(Top()+40+4+84):valign(0):setsize(Width()/2,290):diffuse(Black()):diffusealpha(0.5)
			end;
		};
		Def.Quad{
			Name = "Player Options Quad";
			InitCommand=function(self)
				if pn == PLAYER_1 then self:x(Left()):halign(0) else self:x(Right()):halign(1) end
				self:y(Bottom()-40):valign(1):setsize(Width()/2,18):diffuse(BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2))
			end;
		};
	};
end

t[#t+1] = Def.ActorFrame{
	Def.ActorMultiVertex{
		Name = "Center Quad";
		InitCommand=function(self) self:xy(CenterX(),Top()+127):SetDrawState{Mode=0}:diffuse(BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),1.5)):valign(0) end;
		OnCommand=function(self) self:SetVertices({ {{-244, 0, 0}, Color.White}, {{-44, 316, 0}, Color.White}, {{44, 316, 0}, Color.White}, {{244, 0, 0}, Color.White}, }) end;
	};
	Def.ActorMultiVertex{
		Name = "Song Title Quad";
		InitCommand=function(self) self:xy(CenterX(),Top()+130):SetDrawState{Mode=0}:valign(0):diffusealpha(0.5) end;
		OnCommand=function(self) self:SetVertices({ {{-196, 0, 0}, Color.Black}, {{-185.5, 18, 0}, Color.Black}, {{185.5, 18, 0}, Color.Black}, {{196, 0, 0}, Color.Black}, }) end;
	};
	Def.ActorMultiVertex{
		Name = "Song SubTitle Quad";
		InitCommand=function(self) self:xy(CenterX(),Top()+130+4+18):SetDrawState{Mode=0}:valign(0):diffusealpha(0.5) end;
		OnCommand=function(self) self:SetVertices({ {{-183, 0, 0}, Color.Black}, {{-174, 14, 0}, Color.Black}, {{174, 14, 0}, Color.Black}, {{183, 0, 0}, Color.Black}, }) end;
	};
	Def.ActorMultiVertex{
		Name = "Song Artist Quad";
		InitCommand=function(self) self:xy(CenterX(),Top()+130+8+18+14):SetDrawState{Mode=0}:zoom(1):valign(0):diffusealpha(0.5) end;
		OnCommand=function(self) self:SetVertices({ {{-172, 0, 0}, Color.Black}, {{-162.5, 14, 0}, Color.Black}, {{162.5, 14, 0}, Color.Black}, {{172, 0, 0}, Color.Black}, }) end;
	};
};

t[#t+1] = Def.ActorFrame{
	Def.Quad {
		InitCommand=cmd(xy,CenterX(),Bottom();valign,1;setsize,Width(),16;diffuse,Black());
	};
	Def.Quad {
		InitCommand=cmd(draworder,-1;x,CenterX();y,Bottom();valign,1;zoomto,Width(),40;diffuse,color(LoadFile("ThemeColor.cfg","Settings")));
	};
};

return t